///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _DIALOGS_TABSQL_CPP
#define _DIALOGS_TABSQL_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabSQLDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    static HWND hSQLServer   = NULL;
    static HWND hSQLDriver   = NULL;
    static HWND hSQLDatabase = NULL;
    static HWND hSQLUsername = NULL;
    static HWND hSQLPassword = NULL;

    if(uMsg == WM_INITDIALOG)
    {
        hSQLServer   = GetDlgItem(hWnd, IDC_SERVER);
        hSQLDriver   = GetDlgItem(hWnd, IDC_SQLDRIVER);
        hSQLDatabase = GetDlgItem(hWnd, IDC_SQLDATABASE);

        hSQLUsername = GetDlgItem(hWnd, IDC_SQLUSERNAME);
        hSQLPassword = GetDlgItem(hWnd, IDC_SQLPASSWORD);

        Set_Text(hSQLServer, gsSQLServer);
        Set_Text(hSQLDriver, gsSQLDriver);
        Set_Text(hSQLDatabase, "Master");

		if(_strcmpi(gsDBMode, "Trusted") == 0)
		{
			EnableWindow(hSQLUsername, FALSE);
			EnableWindow(hSQLPassword, FALSE);
		}

		Set_Text(hSQLUsername, gsSQLUserID);
        Set_Text(hSQLPassword, gsSQLPassword);

        return TRUE;
    }

    if(uMsg == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            char lsSQLServer[255 + 1];
            int liSQLServerLen = Get_TextEx(hSQLServer, lsSQLServer, 255);
            if(liSQLServerLen == 0 || liSQLServerLen > 255)
            {
                MessageBox(hWnd, "You must enter a valid SQL server name. Between 1 and 255 characters.", gsTitleCaption, MB_ICONASTERISK);
				SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsSQLDriver[255 + 1];
            int liSQLDriverLen = Get_TextEx(hSQLDriver, lsSQLDriver, 255);
            if(liSQLDriverLen == 0 || liSQLDriverLen > 255)
            {
                MessageBox(hWnd, "You must enter a valid SQL driver name. Between 1 and 255 characters.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsSQLUsername[255 + 1];
            int liSQLUsernameLen = Get_TextEx(hSQLUsername, lsSQLUsername, 255);
            if(liSQLUsernameLen == 0 || liSQLUsernameLen > 255)
            {
                MessageBox(hWnd, "You must enter a valid SQL username. Between 1 and 255 characters.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsSQLPassword[255 + 1];
            int liSQLPasswordLen = Get_TextEx(hSQLPassword, lsSQLPassword, 255);
            if(liSQLPasswordLen < 0 || liSQLPasswordLen > 255)
            {
                MessageBox(hWnd, "You must enter a valid SQL password. Between 0 and 255 characters.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            strcpy_s(gsSQLServer, sizeof(lsSQLServer), lsSQLServer);
            strcpy_s(gsSQLUserID, sizeof(lsSQLUsername), lsSQLUsername);
            strcpy_s(gsSQLPassword, sizeof(lsSQLPassword), lsSQLPassword);
            strcpy_s(gsSQLDriver, sizeof(lsSQLDriver), lsSQLDriver);

            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
